/*******************************************************
Filename		:  FA_HABITAT_RESULT_data1.sql
Release 		:  c2.0, C2.0.1
SIR			:  1496, 1558
Description		:  Migrate data from the TSRRSULT and TSRFACT tables to
			   the FA_HABITAT_RESULT fact table.
Author			:  Bill Nash
Date			:	7/07/2003
				10/08/2003 - Populate Result BLOB_TITLE -JW
				10/29/2003 - Populate Activity BLOB_TITLE -WN
				01/16/04 - SIR 1586 Moved connect string to master install script -JW
				07/23/2004 - added organization_is_number -JW
				08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
				08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
Comments		:  Created HABITAT Result ETL process based on Regular Result.
			:  08/25/2003 Date/time fix. WN
**********************************************************/
set echo off;
spool FA_HABITAT_RESULT_data1.log
show user;

-- create sequence for pk_isn

drop sequence seq_FA_HABITAT_RESULT;

create sequence seq_FA_HABITAT_RESULT
start with 1 increment by 1 nomaxvalue nocycle cache 100;

set serveroutput on
DECLARE

cursor orgs is
	select organization_id, organization_is_number
	from di_org
	order by organization_id;

BEGIN

FOR v_org in orgs loop

INSERT INTO FA_HABITAT_RESULT (pk_isn,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ORGANIZATION_IS_NUMBER,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	FK_UNIT_CONVERSION,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
	BIAS,
	CONF_LVL_CORR_BIAS, 
	BLOB_TITLE,
--activity elements
	ACTIVITY_START_DATE_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	ACTIVITY_TYPE,          
	ACTIVITY_STOP_DATE_TIME,     
	ACT_STOP_TIME_ZONE,     
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
	ACT_BLOB_TITLE,
-- Added hcsc for user defined chars for habitat.
	FK_HCSC,
	TSMPRMVL_IS_NUMBER
)
SELECT
      seq_FA_HABITAT_RESULT.nextval,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
	TO_DATE(DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),
--	TO_DATE(to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 	
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,	
	V_ORG.ORGANIZATION_IS_NUMBER,
	RSULT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
	RSULT.BIAS,
	RSULT.CONF_LVL_CORR_BIAS,
	TRIM(RSULT.BLOB_TITLE),
--activity elements
	TO_DATE(DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),
--	TO_DATE(to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.TYPE_NAME,    
	TO_DATE(DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS'),        
--	TO_DATE(to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS'),'DD-MON-YYYY-HH24:MI:SS'), 
	FDACT.STOP_TIME_ZONE,     
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
	TRIM(FDACT.BLOB_TITLE),
	RSULT.TSRHCSC_IS_NUMBER,
--	RSULT.TSRHCSC_ORG_ID,
	RSULT.TSMPRMVL_IS_NUMBER
FROM STORET1.TSRRSULT RSULT, Storet1.TSRFDACT FDACT
WHERE RSULT.TSRFDACT_IS_NUMBER = FDACT.TSRFDACT_IS_NUMBER
	AND RSULT.TSRFDACT_ORG_ID = FDACT.TSRFDACT_ORG_ID
--changed for habitat logic
      AND RSULT.value_status ='F'
--	AND fdact.medium_type_name in ('Air','Sediment','Soil','Water')
	AND fdact.type_name = 'Field Msr/Obs'
	AND fdact.category_type_name like '%Habitat%'
--
	AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;
end loop;
commit;
end;
/
commit;

alter table FA_HABITAT_RESULT
add constraint pk_HABITAT_result primary key (pk_isn)
using index
tablespace storetindx
storage(initial 2m next 1m);
--storage(initial 10m next 5m);

spool off;